<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Profile extends Model 
{

    protected $table = 'profiles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nickname', 'naf_number', 'quote');
    protected $visible = array('quote');

    public function blogs()
    {
        return $this->hasMany('App\Classes\Blog');
    }

    public function location()
    {
        return $this->belongsTo('App\Classes\Location');
    }

    public function conversations()
    {
        return $this->hasMany('App\Classes\Conversation');
    }

    public function user()
    {
        return $this->belongsTo('App\Classes\User');
    }

    public function games()
    {
        return $this->hasMany('App\Classes\Game');
    }

}